/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id: DPM.h 4490 2020-08-13 13:32:21Z Robert $:

  Description:
    netX DPM definitions

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2010-03-24  File created.

**************************************************************************************/


#ifndef _DPM_H
#define _DPM_H


/*************************************************************************************/


// =====================================================================
//
// Area of host_controlled_dma_register_block
//
// =====================================================================

#define NETX_DPM_HOST_DMA_AREA	0x00103000U


// ---------------------------------------------------------------------
// Register dma_host_reg
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_DMA 0x00000000U
#define NETX_DPM_HOST_DMA     0x00103000U


// =====================================================================
//
// Area of host_controlled_global_register_block
//
// =====================================================================

#define NETX_DPM_HOST_GLOB_AREA	0x00103100U

// ---------------------------------------------------------------------
// Register wdg_host
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_WDG_HOST_TIMEOUT 0x000000C0U
#define NETX_DPM_HOST_WDG_HOST_TIMEOUT     0x001031C0U

// ---------------------------------------------------------------------
// Register cyclic_tmr_control
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_TMR_CTRL 0x000000D0U
#define NETX_DPM_HOST_TMR_CTRL     0x001031D0U

// ---------------------------------------------------------------------
// Register cyclic_tmr_reload
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_TMR_RELOAD 0x000000D4U
#define NETX_DPM_HOST_TMR_RELOAD     0x001031D4U

// ---------------------------------------------------------------------
// Register sta_host
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_SYS_STAT 0x000000D8U
#define NETX_DPM_HOST_SYS_STAT     0x001031D8U

// ---------------------------------------------------------------------
// Register res_reg
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_RES_REQ 0x000000DCU
#define NETX_DPM_HOST_RES_REQ     0x001031DCU

// ---------------------------------------------------------------------
// Register irq_reg_host
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_INT_BASE 0x000000E0U
#define NETX_DPM_HOST_INT_BASE     0x001031E0U

// ---------------------------------------------------------------------
// Register irq_status_0_host
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_INT_STAT0 0x000000E0U
#define NETX_DPM_HOST_INT_STAT0     0x001031E0U

// ---------------------------------------------------------------------
// Register irq_status_1_host
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_INT_STAT1 0x000000E4U
#define NETX_DPM_HOST_INT_STAT1     0x001031E4U

// ---------------------------------------------------------------------
// Register irq_status_2_host
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_INT_STAT2 0x000000E8U
#define NETX_DPM_HOST_INT_STAT2     0x001031E8U

// ---------------------------------------------------------------------
// Register irq_status_3_host
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_INT_STAT3 0x000000ECU
#define NETX_DPM_HOST_INT_STAT3     0x001031ECU

// ---------------------------------------------------------------------
// Register irq_mask_0_host
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_INT_EN0 0x000000F0U
#define NETX_DPM_HOST_INT_EN0     0x001031F0U

// ---------------------------------------------------------------------
// Register irq_mask_1_host
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_INT_EN1 0x000000F4U
#define NETX_DPM_HOST_INT_EN1     0x001031F4U

// ---------------------------------------------------------------------
// Register irq_mask_2_host
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_INT_EN2 0x000000F8U
#define NETX_DPM_HOST_INT_EN2     0x001031F8U

// ---------------------------------------------------------------------
// Register irq_mask_3_host
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_INT_EN3 0x000000FCU
#define NETX_DPM_HOST_INT_EN3     0x001031FCU


// =====================================================================
//
// Area of host_controlled_handshake_register_block
//
// =====================================================================

#define NETX_DPM_HOST_HS_AREA	0x00103200U

// ---------------------------------------------------------------------
// Register host_regs
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_HS_BASE 0x00000000U
#define NETX_DPM_HOST_HS_BASE     0x00103200U


// =====================================================================
//
// Area of netx_controlled_dma_register_block
//
// =====================================================================

#define NETX_DPM_ARM_DMA_AREA	0x00103300U

// ---------------------------------------------------------------------
// Register dma_netx_reg
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_DMA_BASE 0x00000000U
#define NETX_DPM_ARM_DMA_BASE     0x00103300U

// ---------------------------------------------------------------------
// Register wdg_netx
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_WDG_HOST_TIMEOUT 0x000000C0U
#define NETX_DPM_ARM_WDG_HOST_TIMEOUT     0x001034C0U

// ---------------------------------------------------------------------
// Register irq_reg_netx
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_INT_ 0x000000E0U
#define NETX_DPM_ARM_INT_     0x001034E0U

// ---------------------------------------------------------------------
// Register irq_status_0_netx
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_INT_STAT0 0x000000E0U
#define NETX_DPM_ARM_INT_STAT0     0x001034E0U

// ---------------------------------------------------------------------
// Register irq_status_1_netx
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_INT_STAT1 0x000000E4U
#define NETX_DPM_ARM_INT_STAT1     0x001034E4U

// ---------------------------------------------------------------------
// Register irq_status_2_netx
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_INT_STAT2 0x000000E8U
#define NETX_DPM_ARM_INT_STAT2     0x001034E8U

// ---------------------------------------------------------------------
// Register irq_status_3_netx
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_INT_STAT3 0x000000ECU
#define NETX_DPM_ARM_INT_STAT3     0x001034ECU

// ---------------------------------------------------------------------
// Register irq_mask_0_netx
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_INT_EN0 0x000000F0U
#define NETX_DPM_ARM_INT_EN0     0x001034F0U

// ---------------------------------------------------------------------
// Register irq_mask_1_netx
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_INT_EN1 0x000000F4U
#define NETX_DPM_ARM_INT_EN1     0x001034F4U

// ---------------------------------------------------------------------
// Register irq_mask_2_netx
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_INT_EN2 0x000000F8U
#define NETX_DPM_ARM_INT_EN2     0x001034F8U

// ---------------------------------------------------------------------
// Register irq_mask_3_netx
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_INT_EN3 0x000000FCU
#define NETX_DPM_ARM_INT_EN3     0x001034FCU


// =====================================================================
//
// Area of netx_controlled_handshake_register_block
//
// =====================================================================

#define NETX_DPM_ARM_HS_AREA	0x00103500U

// ---------------------------------------------------------------------
// Register netx_regs
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_BASE 0x00000000U
#define NETX_DPM_ARM_HS_BASE     0x00103500U

// ---------------------------------------------------------------------
// Register handshake_ch0
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_DATA0 0x00000000U
#define NETX_DPM_ARM_HS_DATA0     0x00103500U

// ---------------------------------------------------------------------
// Register handshake_ch1
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_DATA1 0x00000004U
#define NETX_DPM_ARM_HS_DATA1     0x00103504U

// ---------------------------------------------------------------------
// Register handshake_ch2
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_DATA2 0x00000008U
#define NETX_DPM_ARM_HS_DATA2     0x00103508U

// ---------------------------------------------------------------------
// Register handshake_ch3
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_DATA3 0x0000000CU
#define NETX_DPM_ARM_HS_DATA3     0x0010350CU

// ---------------------------------------------------------------------
// Register handshake_ch4
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_DATA4 0x00000010U
#define NETX_DPM_ARM_HS_DATA4     0x00103510U

// ---------------------------------------------------------------------
// Register handshake_ch5
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_DATA5 0x00000014U
#define NETX_DPM_ARM_HS_DATA5     0x00103514U

// ---------------------------------------------------------------------
// Register handshake_ch6
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_DATA6 0x00000018U
#define NETX_DPM_ARM_HS_DATA6     0x00103518U

// ---------------------------------------------------------------------
// Register handshake_ch7
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_DATA7 0x0000001CU
#define NETX_DPM_ARM_HS_DATA7     0x0010351CU

// ---------------------------------------------------------------------
// Register handshake_ch8
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_DATA8 0x00000020U
#define NETX_DPM_ARM_HS_DATA8     0x00103520U

// ---------------------------------------------------------------------
// Register handshake_ch9
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_DATA9 0x00000024U
#define NETX_DPM_ARM_HS_DATA9     0x00103524U

// ---------------------------------------------------------------------
// Register handshake_ch10
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_DATA10 0x00000028U
#define NETX_DPM_ARM_HS_DATA10     0x00103528U

// ---------------------------------------------------------------------
// Register handshake_ch11
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_DATA11 0x0000002CU
#define NETX_DPM_ARM_HS_DATA11     0x0010352CU

// ---------------------------------------------------------------------
// Register handshake_ch12
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_DATA12 0x00000030U
#define NETX_DPM_ARM_HS_DATA12     0x00103530U

// ---------------------------------------------------------------------
// Register handshake_ch13
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_DATA13 0x00000034U
#define NETX_DPM_ARM_HS_DATA13     0x00103534U

// ---------------------------------------------------------------------
// Register handshake_ch14
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_DATA14 0x00000038U
#define NETX_DPM_ARM_HS_DATA14     0x00103538U

// ---------------------------------------------------------------------
// Register handshake_ch15
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_DATA15 0x0000003CU
#define NETX_DPM_ARM_HS_DATA15     0x0010353CU


// =====================================================================
//
// Area of netx_controlled_global_register_block_2
//
// =====================================================================

#define NETX_DPM_ARM_GLOB_AREA	0x00103600U

// ---------------------------------------------------------------------
// Register clk_reg
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CLKOUT_CFG 0x00000004U
#define NETX_DPM_ARM_CLKOUT_CFG     0x00103604U

// ---------------------------------------------------------------------
// Register if_conf1
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_IF_CFG0 0x00000008U
#define NETX_DPM_ARM_IF_CFG0     0x00103608U

// ---------------------------------------------------------------------
// Register if_conf2
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_IF_CFG1 0x0000000CU
#define NETX_DPM_ARM_IF_CFG1     0x0010360CU

// ---------------------------------------------------------------------
// Register io_reg
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_IO_BASE 0x00000020U
#define NETX_DPM_ARM_IO_BASE     0x00103620U

// ---------------------------------------------------------------------
// Register io_reg_mode0
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_IO_MODE0 0x00000020U
#define NETX_DPM_ARM_IO_MODE0     0x00103620U

// ---------------------------------------------------------------------
// Register io_reg_drv_en0
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_IO_DRV_EN0 0x00000024U
#define NETX_DPM_ARM_IO_DRV_EN0     0x00103624U

// ---------------------------------------------------------------------
// Register io_reg_data0
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_IO_DATA0 0x00000028U
#define NETX_DPM_ARM_IO_DATA0     0x00103628U

// ---------------------------------------------------------------------
// Register io_reg_reserved0
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_IO_RESERVED_0 0x0000002CU
#define NETX_DPM_ARM_IO_RESERVED_0     0x0010362CU

// ---------------------------------------------------------------------
// Register io_reg_mode1
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_IO_MODE1 0x00000030U
#define NETX_DPM_ARM_IO_MODE1     0x00103630U

// ---------------------------------------------------------------------
// Register io_reg_drv_en1
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_IO_DRV_EN1 0x00000034U
#define NETX_DPM_ARM_IO_DRV_EN1     0x00103634U

// ---------------------------------------------------------------------
// Register io_reg_data1
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_IO_DATA1 0x00000038U
#define NETX_DPM_ARM_IO_DATA1     0x00103638U

// ---------------------------------------------------------------------
// Register io_reg_reserved1
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_IO_RESERVED_1 0x0000003CU
#define NETX_DPM_ARM_IO_RESERVED_1     0x0010363CU

// ---------------------------------------------------------------------
// Register mb_ctrl
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_DB_END0 0x00000040U
#define NETX_DPM_ARM_DB_END0     0x00103640U

// ---------------------------------------------------------------------
// Register hs_ctrl
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_CTRL0 0x00000080U
#define NETX_DPM_ARM_HS_CTRL0     0x00103680U


/*************************************************************************************/

#endif /* _DPM_H */
